@extends('partials.main')
@section('title')
    {{ 'Home Page' }}
@endsection
@section('content')
    <style>
        .title-last {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: #fff;
            font-size: 24px;
            text-align: center;
            margin: 0;
            padding: 0;
            z-index: 2;
        }

        .last-gat {
            height: 250px;
            width: 350px;
            object-fit: cover;
        }

        .tg-homeslidervtwo .tg-slidercontent,
        .tg-homeslidervtwo .tg-slidercontent h1,
        .tg-homeslidervtwo .tg-slidercontent h2 {
            text-align: center;
        }

        .tg-populartourtitle {
            width: 100%;
            float: left;
            height: 48px;
            padding: 0 0 20px;
        }

        .tg-slidercontent h1 {
            color: #fff;
            margin: 0 0 20px;
            font-size: 25px;
            font-weight: bold;
            line-height: 25px;
            text-align: center;

        }

        img.des-first {
            height: 480px !important;
            width: 370px !important;
            object-fit: cover;
        }

        img.des-second {
            width: 400px !important;
            height: 225px !important;
            object-fit: cover;
        }


        img.des-third {
            width: 400px !important;
            height: 225px !important;
            object-fit: cover;
        }

        img.des-fourth {
            height: 480px !important;
            width: 370px !important;
            object-fit: cover;
        }

        @media screen and (max-width: 480px) {
            .tg-infonav ul li+li {
                padding: 0 0 0 25%;
            }
        }

        .alert-container {
            font-family: helvetica, arial;
            font-style: normal;
            font-stretch: normal;
            line-height: normal;
            letter-spacing: normal;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            font-smoothing: antialiased;
            text-rendering: optimizeLegibility;
            z-index: 999999;
        }

        .alert-container {
            -moz-border-radius: 4px;
            -webkit-border-radius: 4px;
            -ms-border-radius: 4px;
            border-radius: 4px;
            z-index: 999999;
        }

        .alert-container {
            background-color: #ff7550;

            border: 1px solid #ff7550;
            z-index: 999999;
        }



        .alert-container {
            position: fixed;
            bottom: 10%;
            left: 0;
            text-align: center;
            width: 90%;
            z-index: 999999;
            right: 0;
            margin: 0 auto;
            color: #000;
        }

        .alert-container .alert {
            text-align: center;
            font-size: 15px;
            z-index: 999999;
            margin-bottom: 0px;
        }

        .tg-description {
            display: -webkit-box;
            -webkit-box-orient: vertical;
            -webkit-line-clamp: 2;
            overflow: hidden;
            text-overflow: ellipsis;
            max-height: 20.4em;
        }

        #tg-homebannerslider {
            height: 100vh;

            overflow: hidden;

        }

        video {
            width: 100%;
        }

        .video-background {
            width: 100%;
            height: 100%;
            min-height: 100%;

            object-fit: cover;
        }

        .tg-slidercontent h2 {
            font-size: 30px;
            line-height: 30px;
            font-family: 'Montserrat', Arial, Helvetica, sans-serif;
        }

        @media (max-width: 768px) {
            #tg-homebannerslider {
                height: 100vh;

            }
        }

        @media (max-width: 768px) {
            .bannerimg {
                padding: 6px;

            }
        }

        @media (min-width: 1250px) {
            .tg-middle {
                display: none;
            }
        }

        .scroll-down-arrow {
            position: absolute;
            bottom: 50px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 2;
        }

        .scroll-down-arrow a {
            text-decoration: none;
            color: #fff;
            font-size: 24px;
        }

        .scroll-down-arrow a i {
            display: block;
            animation: bounce 3s infinite;
        }

        @keyframes bounce {

            0%,
            20%,
            50%,
            80%,
            100% {
                transform: translateY(0);
            }

            40% {
                transform: translateY(-20px);
            }

            60% {
                transform: translateY(-10px);
            }
        }

        .videocaption {
            position: absolute;
            bottom: 30%;
            left: 50%;
            transform: translateX(-50%);
            z-index: 2;
            background-color: rgba(0, 0, 0, 0.5);
            padding: 20px;
            border-radius: 5px;
        }

        .tg-parallax .tg-sectionspace {
            height: 520px;
            background: rgba(0, 0, 0, 0.50);
        }

        .mask {
            mask-image: url('images/frame-design.svg');

            mask-mode: alpha;
            -webkit-mask-image: url('images/frame-design.svg');
            -webkit-mask-mode: alpha;

            -webkit-mask-repeat: no-repeat;
            mask-repeat: no-repeat;
        }

        a#showButton {
            background: gold;
        }

        .tg-populardestination img {
            height: 250px;
            object-fit: cover;
        }

        @media only screen and (min-width: 992px) {
            .imgBorder {
                cursor: pointer;
                height: auto;
                width: 50vw;

                padding: 10px 0px 10px 0px;
                text-align: center;

            }
        }

        @media only screen and (max-width: 600px) {
            .videocaption {

                bottom: 28%;
                width: 92%;

            }

            video {
                height: 100vh;
                width: auto;
            }
        }

        @media screen and (max-width: 395px) {
            .slidehader {
                font-size: 35px !important;
            }

            .tg-homeslidervtwo .tg-slidercontent h1 {
                line-height: 10px;
            }

            .pd-one,
            .pd-two {
                padding-top: 50px !important;

            }

            .tg-slidercontent h1 {
                font-size: 20px !important;
            }

            .scroll-down-arrow {
                bottom: 170px;
            }

        }



        @media screen and (max-width: 500px) {
            .socialIconsHeader {
                display: none
            }

            .mailMobile {
                float: right !important;
                padding: 0 !important;
                padding-right: 30px !important;
            }

            .videoText2 {
                font-size: 22px !important;
            }
        }

        .imgBorder {
            cursor: pointer;
        }

        .itineraryDesc {
          height: 50px;
        }


        /* Styles for the overlay */
        .overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            justify-content: center;
            align-items: center;
            z-index: 1;
        }

        /* Styles for the popup */
        .popup {
            background: #fff;
            padding: 20px;
            border-radius: 5px;
            max-width: 400px;
            text-align: center;
        }

        /* Close button styles */
        .close-btn {
            cursor: pointer;
            position: absolute;
            top: 10px;
            right: 10px;
        }

        .snowflake {
            position: absolute;
            font-size: 0.7em;
            color: #fff;
            pointer-events: none;
            animation: fall linear infinite;
        }

        @keyframes fall {
            0% {
                transform: translateY(-10vh);
            }

            100% {
                transform: translateY(110vh);
            }
        }

        .center-review {
            text-align: -webkit-center;
        }

        /* ///conteiner/// */
        .container-new {
            width: 100%;
            padding-right: 25px;
            padding-left: 25px;
            margin-right: auto;
            margin-left: auto;
        }
    </style>
    <!--************************************
                                                                            
                                                                                                                                                                                                                                                                                 Home Slider Start
                                                                         *************************************-->


    <div class="overlay" id="popupOverlay">
        <div class="popup">
            <span class="close-btn" onclick="closePopup()">&times;</span>
            <h2></h2>
            <p></p>
        </div>
    </div>


    <div id="tg-homebannerslider" class="tg-homebannerslider tg-haslayout">
        <div class="video-background">
            <video autoplay muted loop playsinline>
                <source src="../video/{{ $video->video }}" type="video/mp4">



            </video>
        </div>
        <div class="videocaption">
            <div class="container">
                <div class="row">
                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                        <div class="tg-slidercontent">
                            <h1 style="color: {{ $s29->value }}">{{ $s19->value }}</h1>
                            <h2 class="videoText2" style="color: {{ $s30->value }}">{{ $s20->value }}</h2>
                        </div>
                    </div>
                </div>
                <div class="tg-middle">

                    <div class="tg-userbox">

                        <a class="tg-btn" id="showButton" onclick="showOptionsPopup()">
                            <span>PLACE INQUIRY </span>
                        </a>



                    </div>
                </div>
            </div>

        </div>
        <div class="scroll-down-arrow">
            <a href="#tg-main"><i style="color: {{ $s29->value }}" class="fas fa-chevron-down"></i></a>
        </div>
    </div>

    <section>
        <section style="padding-top:20px;" class="tg-sectionspace tg-toppadding tg-haslayout">
            <div class="container-new">
                <div class="row">
                    <div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6" style="border:1px solid #ccc">
                            <a href="{{ route('loyalty-programme') }}">
                                <div style="padding-top:5px;text-align: center;" class="bannerimg">
                                    <img class="imgBorder" src="../thumbnails/{{ $s31->value }}" alt="">
                                </div>
                            </a>
                        </div>



                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6" style="border:1px solid #ccc">
                            <a href="{{ route('dialog-5g') }}">
                                <div style="padding-top:5px;text-align: center;" class="bannerimg">
                                    <img class="imgBorder" src="../thumbnails/{{ $s32->value }}" alt="">
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <main id="tg-main" class="tg-main tg-haslayout">



            <section style="padding-top:40px;" class="tg-sectionspace tg-toppadding tg-haslayout">
                <div class="container">
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                            <div class="tg-sectionhead tg-sectionheadvtwo">
                                <div class="tg-sectiontitle">
                                    <h2>{{ $s10->value }}</h2>
                                </div>
                                <div class="tg-description">
                                    <p>{{ $s11->value }}
                                    </p>
                                </div>
                            </div>
                            <div id="tg-populartoursslider"
                                class="tg-populartoursslider tg-populartours tg-populartoursvtwo owl-carousel">

                                @foreach ($vehicle as $item)
                                    <div class="item tg-populartour">
                                        <figure>
                                            <a href="/rent-vehicle/#{{ $item->name }}">
                                                <img src="{{ asset('thumbnails/' . $item->image) }}"
                                                    alt="image destinations" class="advance-btn"></a>

                                        </figure>
                                        <div class="tg-populartourcontent">
                                            <div style="text-align: center;" class="tg-populartourtitle">
                                                <h3><a href="/rent-vehicle/#{{ $item->name }}"> {{ $item->name }}</a>
                                                </h3>
                                            </div>


                                        </div>
                                    </div>
                                @endforeach


                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--************************************
                                                                                                                                                                                                                                                                                 Our Guides End
                                                                                                                                                                                                                                                                                   *************************************-->
            <!--************************************
                                                                                                                                                                                                                                                                                         Popular Destination Start
                                                                                                                                                                                                                                                                                       *************************************-->
            <section id="tg-pop" class="tg-parallax" data-appear-top-offset="600" data-parallax="scroll"
                data-image-src="{{ asset('thumbnails/' . $s14->value) }}">
                <div class="tg-sectionspace tg-haslayout">
                    <div class="container">
                        <div class="row">
                            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                <div class="tg-sectionhead">
                                    <div class="tg-sectiontitle">
                                        <h2 style="line-height:1">{{ $s12->value }}</h2>
                                    </div>
                                    <div class="tg-description">
                                        <p>{{ $s13->va }}</p>
                                    </div>
                                </div>
                                <div id="tg-populardestinationslider"
                                    class="tg-populardestinationslider tg-populardestinations owl-carousel">
                                    @foreach ($safarilist as $item)
                                        <div class="item tg-populardestination">
                                            <figure>
                                                <a href="/safari/{{ $item->slug }}"> <img
                                                        src="{{ asset('thumbnails/' . $item->thumbnail) }}"
                                                        alt="image destinations"></a>
                                                <figcaption>
                                                    <h3><a href="/safari/{{ $item->slug }}">{{ $item->name }}</a></h3>
                                                    <div class="tg-description">
                                                        <p>Beautiful Safari In {{ $item->park }}</p>
                                                    </div>
                                                </figcaption>
                                            </figure>
                                        </div>
                                    @endforeach


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--************************************
                                                                                                                                                                                                                                                                                         Popular Tour End
                                                                                                                                                                                                                                                                                       *************************************-->


            <!--************************************
                                                                                                                                                                                                                                                                                         Tranding Trips Start
                                                                                                                                                                                                                                                                                       *************************************-->
            <section class="tg-sectionspace tg-haslayout">
                <div class="container">
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                            <div class="tg-sectionhead tg-sectionheadvtwo">
                                <div class="tg-sectiontitle">
                                    <h2>{!! $s15->value !!}</h2>
                                </div>
                                <div class="tg-description">
                                    <p>{{ $s16->value }}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">

                        @foreach ($package as $package)
                            <div class="col-xs-12 col-sm-4 col-md-4 col-lg-4 itineraryBox">
                                <div class="tg-trendingtrip">
                                    <figure>
                                        <a href="/tour-detail/{{ $package->slug }}">
                                            <div class="mask">
                                                <img src="{{ asset('thumbnails/' . $package->thumbnail) }}"
                                                    class="Itinerary-gat" alt="image destinations">
                                            </div>
                                        </a>
                                    </figure>
                                    <div class="tg-populartourcontent">
                                        <div class="tg-populartourtitle">
                                            <h3><a href="/tour-detail/{{ $package->slug }}">
                                                    {{ $package->title }}
                                                </a></h3>
                                        </div>
                                        <div class="tg-description itineraryDesc">
                                            <p> {!! $package->description !!} </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="tg-populartourfoot">
                                    <form action="/quotation" method="post">
                                        @csrf
                                        <input name="type" type="hidden" value="pack">
                                        <input name="name" type="hidden" value=" {{ $package->title }} ">
                                        <button class="tg-btnaddtocart" type="submit"> <i class="icon-icons240"></i>
                                            <span>Request Quote </span></button>
                                    </form>
                                </div>
                            </div>

                            @if ($loop->index == 2)
                    </div>
                    <div class="row">
                        @endif
                        @endforeach
                    </div>
                </div>

            </section>
            <!--************************************
                                                                                                                                                                                                                                                                                 Tranding Trips End
                                                                                                                                                                                                                                                                                   *************************************-->




            <!--************************************
                                                                                                                                                                                                                                                                                         Call To Action Start
                                                                                                                                                                                                                                                                                       *************************************-->
            <section class="tg-parallax" data-appear-top-offset="600" data-parallax="scroll"
                data-image-src="{{ asset('thumbnails/' . $s18->value) }}">
                <div class="tg-sectionspace tg-zerobottompadding tg-haslayout">
                    <div class="container">
                        <div class="row">
                            <div class="center-review">
                                <div id="TA_selfserveprop10" class="TA_selfserveprop">
                                    <ul id="xUCses6D4N" class="TA_links c7bkkrk">
                                        <li id="Ayr8gfDxWFJg" class="PgJioZfIX"><a target="_blank"
                                                href="https://www.tripadvisor.com/Attraction_Review-g297897-d15278876-Reviews-Lanka_Getaways-Negombo_Western_Province.html"><img
                                                    src="https://www.tripadvisor.com/img/cdsi/img2/branding/v2/Tripadvisor_lockup_horizontal_secondary_registered-11900-2.svg"
                                                    alt="TripAdvisor" /></a></li>
                                    </ul>
                                </div>
                                <script async
                                    src="https://www.jscache.com/wejs?wtype=selfserveprop&amp;uniq=10&amp;locationId=15278876&amp;lang=en_US&amp;rating=true&amp;nreviews=4&amp;writereviewlink=true&amp;popIdx=true&amp;iswide=true&amp;border=true&amp;display_version=2"
                                    data-loadtrk onload="this.loadtrk=true"></script>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--************************************
                                                                                                                                                                                                                                                                                         Call To Action End
                                                                                                                                                                                                                                                                                       *************************************-->

            <!--************************************
                                                                                                                                                                                                                                                                                         Top Destination Start
                                                                                                                                                                                                                                                                                       *************************************-->
            <section class="tg-sectionspace tg-haslayout">
                <div class="container">
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                            <div class="tg-sectionhead tg-sectionheadvtwo">
                                <div class="tg-sectiontitle">
                                    <h2>{!! $s21->value !!}</h2>
                                </div>
                                <div class="tg-description">
                                    <p>{!! $s22->value !!}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                            <div class="tg-themetabs">

                                <div class="tg-themetabcontent">
                                    <div class="tg-topdestinations">
                                        <div class="row">
                                            <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">

                                                <div class="tg-topdestination">
                                                    <figure>
                                                        <a href="/destinations/{{ $first->slug }}"
                                                            class="tg-btnviewall">View All Tours</a>
                                                        <a href="/destinations/{{ $first->slug }}">
                                                            <img class="des-first"
                                                                src="{{ asset('thumbnails/' . $first->thumbnail) }}"
                                                                alt="image description"></a>
                                                        <figcaption>
                                                            <h2><a href="/destinations/{{ $first->slug }}">{{ $first->title }}
                                                                </a></h2>
                                                            {{-- <span class="tg-totaltours">17 Places</span> --}}
                                                        </figcaption>
                                                    </figure>
                                                </div>


                                            </div>
                                            <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">

                                                <div class="tg-topdestination">
                                                    <figure>
                                                        <a href="/destinations/{{ $second->slug }}"
                                                            class="tg-btnviewall">View All
                                                            Tours</a>
                                                        <a href="/destinations/{{ $second->slug }}"> <img
                                                                class="des-second"
                                                                src="{{ asset('thumbnails/' . $second->thumbnail) }}"
                                                                alt="image description"></a>
                                                        <figcaption>
                                                            <h2><a
                                                                    href="/destinations/{{ $second->slug }}">{{ $second->title }}</a>
                                                            </h2>
                                                            {{-- <span class="tg-totaltours">11 Places</span> --}}
                                                        </figcaption>
                                                    </figure>
                                                </div>

                                                <div class="tg-topdestination">
                                                    <figure>
                                                        <a href="/destinations/{{ $third->slug }}"
                                                            class="tg-btnviewall">View All Tours</a>
                                                        <a href="/destinations/{{ $third->slug }}"> <img
                                                                class="des-third"
                                                                src="{{ asset('thumbnails/' . $third->thumbnail) }}"
                                                                alt="image description"></a>
                                                        <figcaption>
                                                            <h2><a
                                                                    href="/destinations/{{ $third->slug }}">{{ $third->title }}</a>
                                                            </h2>
                                                            {{-- <span class="tg-totaltours">25 Places</span> --}}
                                                        </figcaption>
                                                    </figure>
                                                </div>
                                            </div>
                                            <div class="col-xs-12 col-sm-12 col-md-4 col-lg-4">

                                                <div class="tg-topdestination">
                                                    <figure>
                                                        <a href="/destinations/{{ $fourth->slug }}"
                                                            class="tg-btnviewall">View All Tours</a>
                                                        <a href="/destinations/{{ $fourth->slug }}"> <img
                                                                class="des-fourth"
                                                                src="{{ asset('thumbnails/' . $fourth->thumbnail) }}"
                                                                alt="image description"></a>
                                                        <figcaption>
                                                            <h2><a
                                                                    href="/destinations/{{ $fourth->slug }}">{{ $fourth->title }}</a>
                                                            </h2>
                                                            {{-- <span class="tg-totaltours">10 Places</span> --}}
                                                        </figcaption>
                                                    </figure>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </section>


            <section class="tg-sectionspace tg-zerotoppadding tg-haslayout">
                <div class="container">
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                            <div class="tg-sectionhead tg-sectionheadvtwo">
                                <div class="tg-sectiontitle">
                                    <h2>{!! $s23->value !!}</h2>
                                </div>
                                <div class="tg-description">
                                    <p>{!! $s24->value !!}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-3 col-lg-3">
                            <div class="tg-last">
                                <figure>
                                    <a href="/tips">
                                        <div class="mask">
                                            <img src="{{ asset('thumbnails/' . $s25->value) }}" class="last-gat"
                                                alt="">
                                            <h1 class="title-last">Tips</h1>
                                        </div>
                                    </a>
                                </figure>

                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-3 col-lg-3">
                            <div class="tg-last">
                                <figure>
                                    <a href="/blog">
                                        <div class="mask">
                                            <img src="{{ asset('thumbnails/' . $s26->value) }}" class="last-gat"
                                                alt="">
                                            <h1 class="title-last">Blog</h1>
                                        </div>
                                    </a>
                                </figure>

                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-3 col-lg-3">
                            <div class="tg-last">
                                <figure>
                                    <a href="/news">
                                        <div class="mask">
                                            <img src="{{ asset('thumbnails/' . $s27->value) }}" class="last-gat"
                                                alt="">
                                            <h1 class="title-last">News</h1>
                                        </div>
                                    </a>
                                </figure>

                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-3 col-lg-3">
                            <div class="tg-last">
                                <figure>
                                    <a href="/video-portal">
                                        <div class="mask">
                                            <img src="{{ asset('thumbnails/' . $s33->value) }}" class="last-gat"
                                                alt="">
                                            <h1 class="title-last">Melani's Map</h1>
                                        </div>
                                    </a>
                                </figure>

                            </div>
                        </div>
                        {{-- <div style="padding: 0 10px" class="tg-posts">
                            {!! $last->description !!}
                        </div> --}}
                    </div>
                </div>
            </section>



            <div style="display:none" class="alert-container">
                <div class="alert alertContent">
                    {{ Session::get('alert-success') }}
                </div>
            </div>



            <script>
                @if (Session::has('alert-success'))
                    var alert = $(".alert-container");
                    alert.slideDown();
                    window.setTimeout(function() {
                        alert.slideUp();
                    }, 3500);
                @endif
            </script>
            <script>
                $(document).ready(function() {

                    $(".scroll-down-arrow a").on("click", function(event) {
                        event.preventDefault();
                        var targetId = $(this).attr("href");

                        $("html, body").animate({
                            scrollTop: $(targetId).offset().top
                        }, 1000);
                    });
                });
            </script>


            <!--            <script>
                -- >

                <
                !-- function openPopup() {
                    -- >
                    <
                    !--document.getElementById('popupOverlay').style.display = 'flex';
                    -- >
                    <
                    !--
                }-- >


                <
                !-- function closePopup() {
                    -- >
                    <
                    !--document.getElementById('popupOverlay').style.display = 'none';
                    -- >
                    <
                    !--
                }-- >


                <
                !--window.onload = function() {
                    -- >
                    <
                    !--openPopup();
                    -- >
                    <
                    !--
                };
                -- >
                <
                !--
            </script>-->


            <script>
                document.addEventListener("DOMContentLoaded", function() {
                    const numSnowflakes = 70;
                    const body = document.body;

                    for (let i = 0; i < numSnowflakes; i++) {
                        createSnowflake();
                    }

                    function createSnowflake() {
                        const snowflake = document.createElement("div");
                        snowflake.className = "snowflake";
                        snowflake.innerHTML = "❄";
                        snowflake.style.left = `${Math.random() * 100}vw`;
                        snowflake.style.animationDuration = `${Math.random() * 10 + 1}s`;
                        snowflake.style.animationDelay = `-${Math.random()}s`;

                        body.appendChild(snowflake);

                        snowflake.addEventListener("animationiteration", function() {
                            // Reset snowflake position when it goes out of view
                            snowflake.style.left = `${Math.random() * 100}vw`;
                            snowflake.style.animationDuration = `${Math.random() * 10 + 1}s`;
                            snowflake.style.animationDelay = `-${Math.random()}s`;
                        });
                    }
                });
            </script>

        </main>
    @endsection
